<h3>User Details</h3>
<?php
//pr($link_referrers);
?>
<div class="row">
    <div class="col-sm-6">
        <div class="percentage pie-chart" data-percent="100" style="width: 110px; height: 110px; line-height: 110px;"><span><?php echo $totalLinks; ?></span></div>
        <div class="chart-label">Total Links</div>
    </div>
    <div class="col-sm-6">
        <div class="percentage pie-chart" data-percent="100" style="width: 110px; height: 110px; line-height: 110px;"><span><?php echo $totalHits; ?></span></div>
        <div class="chart-label">Total Clicks</div>
    </div>
</div>



<div class="row">
    <div class="col-sm-12">
        <!-- Info box -->
        <div class="box box-info">
            <div class="box-header">
                <i class="glyphicon glyphicon-stats"></i> <h3 class="box-title">Clicks on last 30 days</h3>
            </div>
            <div class="box-body">
                <div class="chart" id="last-month-hits" style="position: relative; height: 300px; width: 100%;"></div>
            </div><!-- /.box-body -->
        </div><!-- /.box -->



        <script>
            jQuery(document).ready(function () {
                new Morris.Line({
                    element: 'last-month-hits',
                    resize: true,
                    data: [
<?php
$last30days = array();
for ($i = 30; $i > 0; $i--) {
    $last30days[date('d-m-Y', strtotime('-' . $i . ' days'))] = 0;
}
foreach ($linksStats as $linksStat) {
    if (empty($linksStat[0]["statDateCount"])) {
        $linksStat[0]["statDateCount"] = 0;
    }
    $last30days[$linksStat[0]["statDate"]] = $linksStat[0]["statDateCount"];
}

foreach ($last30days as $key => $value) {
    $date = date("Y-m-d", strtotime($key));
    echo '{date: "' . $date . '", clicks: ' . $value . '},';
}
?>
                    ],
                    xkey: 'date',
                    xLabels: 'day',
                    ykeys: ['clicks'],
                    labels: ['Clicks'],
                    lineWidth: 2,
                    hideHover: 'auto',
                    smooth: false
                });
            });
        </script>
    </div>
</div>


<div class="table-responsive">
    <table class="table table-striped">
        <tr>
            <th><?php echo $this->Paginator->sort('Link.id', 'ID'); ?></th>
            <th><?php echo $this->Paginator->sort('Link.alias', 'alias'); ?></th>
            <th><?php echo $this->Paginator->sort('Link.title', 'Title'); ?></th>
            <th><?php echo $this->Paginator->sort('Link.clicks', 'Clicks'); ?></th>
            <th>Redirect</th>
            <th><?php echo $this->Paginator->sort('Link.updated', 'Updated'); ?></th>
            <th><?php echo $this->Paginator->sort('Link.created', 'Created'); ?></th>
            <th>Actions</th>
        </tr>
        <?php foreach ($user_links as $link) : ?>
            <tr>
                <td><?php echo $link['Link']['id']; ?></td>
                <td><?php echo $this->Html->link($link['Link']['alias'], array('controller' => 'stats', 'action' => 'view', $link['Link']['id'])); ?></td>
                <td><?php echo $link['Link']['title']; ?></td>
                <td><?php echo $link['Link']['clicks']; ?></td>
                <td><?php echo $link['Link']['redirection_type']; ?></td>
                <td><?php echo $link['Link']['updated']; ?></td>
                <td><?php echo $link['Link']['created']; ?></td>
                <td>
                    <?php echo $this->Html->link('<i class="fa fa-edit"></i> Edit', array('controller' => 'links', 'action' => 'edit', $link['Link']['id']), array('escape' => false, 'class' => 'btn btn-primary btn-xs')); ?> <?php echo $this->Form->postLink('<i class="fa fa-trash-o"></i> Delete', array('controller' => 'links', 'action' => 'delete', $link['Link']['id']), array('escape' => false, 'class' => 'btn btn-danger btn-xs', 'confirm' => 'Are you sure?')); ?>
                </td>
            </tr>
        <?php endforeach; ?>
        <?php unset($link); ?>
    </table>
</div>


<ul class="pagination">
    <!-- Shows the previous link -->
    <?php echo $this->Paginator->prev('«', array('tag' => 'li'), null, array('class' => 'disabled', 'tag' => 'li', 'disabledTag' => 'a')); ?>
    <!-- Shows the page numbers -->
    <?php //echo $this->Paginator->numbers();?>
    <?php
    echo $this->Paginator->numbers(array(
        'modulus' => 4,
        'separator' => '',
        'ellipsis' => '<li><a>...</a></li>',
        'tag' => 'li',
        'currentTag' => 'a',
        'first' => 2,
        'last' => 2
    ));
    ?>
    <!-- Shows the next link -->
    <?php echo $this->Paginator->next('»', array('tag' => 'li'), null, array('class' => 'disabled', 'tag' => 'li', 'disabledTag' => 'a')); ?>
</ul>




<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title">Referrers</h3>
    </div>
    <div class="panel-body">
        <ul class="list-unstyled">
            <?php foreach ($link_referrers as $link_referrer) : ?>
                <li><?php echo $link_referrer['Stat']['referer_domain']; ?> <span class="badge pull-right"><?php echo $link_referrer[0]['num']; ?></span></li>
            <?php endforeach; ?>
        </ul>
    </div>
</div>








<style>
    .pie-chart {
        position:relative;
        text-align:center;
        margin: 0 auto;
    }

    .pie-chart canvas {
        position:absolute;
        top:0;
        left:0;
    }
    .percentage, .chart-label {
        text-align:center;
        color:#333;
        font-weight:100;
        font-size:1.2em;
        margin-bottom:0.3em;
    }
</style>

<script>
    jQuery(function () {
        jQuery('.pie-chart').easyPieChart({
            //your options goes here
        });
    });
</script>
